'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let UserLogListener = class UserLogListener {
    /**
   * Calls a predefined function with the packets data
   * @param {CopyFactoryUserLogMessage[]} logEvent user log event with an array of packets
   */ onUserLog(logEvent) {
        return _async_to_generator(function*() {
            throw Error('Abstract method onUserLog has no implementation');
        })();
    }
    /**
   * Calls a predefined function with the received error
   * @param {Error} error error received during retrieve attempt
   */ onError(error) {
        return _async_to_generator(function*() {})();
    }
};
/**
 * User log listener for handling a stream of user log events
 */ export { UserLogListener as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogVXNlciBsb2cgbGlzdGVuZXIgZm9yIGhhbmRsaW5nIGEgc3RyZWFtIG9mIHVzZXIgbG9nIGV2ZW50c1xuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBVc2VyTG9nTGlzdGVuZXIge1xuXG4gIC8qKlxuICAgKiBDYWxscyBhIHByZWRlZmluZWQgZnVuY3Rpb24gd2l0aCB0aGUgcGFja2V0cyBkYXRhXG4gICAqIEBwYXJhbSB7Q29weUZhY3RvcnlVc2VyTG9nTWVzc2FnZVtdfSBsb2dFdmVudCB1c2VyIGxvZyBldmVudCB3aXRoIGFuIGFycmF5IG9mIHBhY2tldHNcbiAgICovXG4gIGFzeW5jIG9uVXNlckxvZyhsb2dFdmVudCkge1xuICAgIHRocm93IEVycm9yKCdBYnN0cmFjdCBtZXRob2Qgb25Vc2VyTG9nIGhhcyBubyBpbXBsZW1lbnRhdGlvbicpO1xuICB9XG5cbiAgLyoqXG4gICAqIENhbGxzIGEgcHJlZGVmaW5lZCBmdW5jdGlvbiB3aXRoIHRoZSByZWNlaXZlZCBlcnJvclxuICAgKiBAcGFyYW0ge0Vycm9yfSBlcnJvciBlcnJvciByZWNlaXZlZCBkdXJpbmcgcmV0cmlldmUgYXR0ZW1wdFxuICAgKi9cbiAgYXN5bmMgb25FcnJvcihlcnJvcikge31cblxufSJdLCJuYW1lcyI6WyJVc2VyTG9nTGlzdGVuZXIiLCJvblVzZXJMb2ciLCJsb2dFdmVudCIsIkVycm9yIiwib25FcnJvciIsImVycm9yIl0sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBS2UsSUFBQSxBQUFNQSxrQkFBTixNQUFNQTtJQUVuQjs7O0dBR0MsR0FDRCxBQUFNQyxVQUFVQyxRQUFRO2VBQXhCLG9CQUFBLFlBQTBCO1lBQ3hCLE1BQU1DLE1BQU0sbURBQW1EO1FBQ2pFOztJQUVBOzs7R0FHQyxHQUNELEFBQU1DLFFBQVFDLEtBQUs7ZUFBbkIsb0JBQUEsWUFBcUIsQ0FBQzs7QUFFeEI7QUFuQkE7O0NBRUMsR0FDRCxTQUFxQkwsNkJBZ0JwQiJ9