"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return MetaApiClient;
    }
});
const _methodAccessError = /*#__PURE__*/ _interop_require_default(require("./methodAccessError"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let MetaApiClient = class MetaApiClient {
    /**
   * Returns type of current token
   * @returns {string} Type of current token
   * @protected
   */ get _tokenType() {
        if (typeof this._token === "string" && this._token.split(".").length === 3) {
            return "api";
        }
        if (typeof this._token === "string" && this._token.split(".").length === 1) {
            return "account";
        }
        return "";
    }
    /**
   * Checks that current token is not api token
   * @returns {boolean} Indicator of absence api token
   * @protected
   */ _isNotJwtToken() {
        return typeof this._token !== "string" || this._token.split(".").length !== 3;
    }
    /**
   * Checks that current token is not account token
   * @returns {boolean} Indicator of absence account token
   * @protected
   */ _isNotAccountToken() {
        return typeof this._token !== "string" || this._token.split(".").length !== 1;
    }
    /**
   * Handles no accessing to the method
   * @param {string} methodName Name of method
   * @protected
   * @throws
   */ _handleNoAccessError(methodName) {
        return Promise.reject(new _methodAccessError.default(methodName, this._tokenType));
    }
    /**
   * Constructs MetaTrader API client instance
   * @param {HttpClient} httpClient HTTP client
   * @param {DomainClient} domainClient domain client
   */ constructor(httpClient, domainClient){
        this._httpClient = httpClient;
        this._domainClient = domainClient;
        this._host = `https://mt-provisioning-api-v1.${domainClient.domain}`;
        this._token = domainClient.token;
    }
};

//# sourceMappingURL=data:application/json;base64,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