"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return ProvisioningProfile;
    }
});
let ProvisioningProfile = class ProvisioningProfile {
    /**
   * Returns profile id
   * @return {String} profile id
   */ get id() {
        return this._data._id;
    }
    /**
   * Returns profile name
   * @return {String} profile name
   */ get name() {
        return this._data.name;
    }
    /**
   * Returns profile version. Possible values are 4 and 5
   * @return {Number} profile version
   */ get version() {
        return this._data.version;
    }
    /**
   * Returns profile status. Possible values are new and active
   * @return {String} profile status
   */ get status() {
        return this._data.status;
    }
    /**
   * Returns broker timezone name from Time Zone Database
   * @return {String} broker timezone name
   */ get brokerTimezone() {
        return this._data.brokerTimezone;
    }
    /**
   * Returns broker DST timezone name from Time Zone Database
   * @return {String} broker DST switch timezone name
   */ get brokerDSTSwitchTimezone() {
        return this._data.brokerDSTSwitchTimezone;
    }
    /**
   * Reloads provisioning profile from API
   * @return {Promise} promise resolving when provisioning profile is updated
   */ async reload() {
        this._data = await this._provisioningProfileClient.getProvisioningProfile(this.id);
    }
    /**
   * Removes provisioning profile. The current object instance should be discarded after returned promise resolves.
   * @return {Promise} promise resolving when provisioning profile is removed
   */ remove() {
        return this._provisioningProfileClient.deleteProvisioningProfile(this.id);
    }
    /**
   * Uploads a file to provisioning profile.
   * @param {String} fileName name of the file to upload. Allowed values are servers.dat for MT5 profile, broker.srv for
   * MT4 profile
   * @param {String|Buffer} file path to a file to upload or buffer containing file contents
   * @return {Promise} promise which resolves when the file was uploaded
   */ uploadFile(fileName, file) {
        return this._provisioningProfileClient.uploadProvisioningProfileFile(this.id, fileName, file);
    }
    /**
   * Updates provisioning profile
   * @param {ProvisioningProfileUpdateDto} profile provisioning profile update
   * @return {Promise} promise resolving when provisioning profile is updated
   */ async update(profile) {
        await this._provisioningProfileClient.updateProvisioningProfile(this.id, profile);
        await this.reload();
    }
    /**
   * Constructs a provisioning profile entity
   * @param {ProvisioningProfileDto} data provisioning profile data
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */ constructor(data, provisioningProfileClient){
        this._data = data;
        this._provisioningProfileClient = provisioningProfileClient;
    }
};

//# sourceMappingURL=data:application/json;base64,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