'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let ReconnectListener = class ReconnectListener {
    /**
   * Invoked when connection to MetaTrader terminal re-established
   * @param {String} region reconnected region
   * @param {Number} instanceNumber reconnected instance number
   * @return {Promise} promise which resolves when the asynchronous event is processed
   */ onReconnected(region, instanceNumber) {
        return _async_to_generator(function*() {})();
    }
};
/**
 * Defines interface for a websocket reconnect listener class
 */ export { ReconnectListener as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogRGVmaW5lcyBpbnRlcmZhY2UgZm9yIGEgd2Vic29ja2V0IHJlY29ubmVjdCBsaXN0ZW5lciBjbGFzc1xuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBSZWNvbm5lY3RMaXN0ZW5lciB7XG5cbiAgLyoqXG4gICAqIEludm9rZWQgd2hlbiBjb25uZWN0aW9uIHRvIE1ldGFUcmFkZXIgdGVybWluYWwgcmUtZXN0YWJsaXNoZWRcbiAgICogQHBhcmFtIHtTdHJpbmd9IHJlZ2lvbiByZWNvbm5lY3RlZCByZWdpb25cbiAgICogQHBhcmFtIHtOdW1iZXJ9IGluc3RhbmNlTnVtYmVyIHJlY29ubmVjdGVkIGluc3RhbmNlIG51bWJlclxuICAgKiBAcmV0dXJuIHtQcm9taXNlfSBwcm9taXNlIHdoaWNoIHJlc29sdmVzIHdoZW4gdGhlIGFzeW5jaHJvbm91cyBldmVudCBpcyBwcm9jZXNzZWRcbiAgICovXG4gIGFzeW5jIG9uUmVjb25uZWN0ZWQocmVnaW9uLCBpbnN0YW5jZU51bWJlcikge31cbiAgXG59XG4iXSwibmFtZXMiOlsiUmVjb25uZWN0TGlzdGVuZXIiLCJvblJlY29ubmVjdGVkIiwicmVnaW9uIiwiaW5zdGFuY2VOdW1iZXIiXSwibWFwcGluZ3MiOiJBQUFBOzs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFLZSxJQUFBLEFBQU1BLG9CQUFOLE1BQU1BO0lBRW5COzs7OztHQUtDLEdBQ0QsQUFBTUMsY0FBY0MsTUFBTSxFQUFFQyxjQUFjO2VBQTFDLG9CQUFBLGFBQTZDOztBQUUvQztBQWJBOztDQUVDLEdBQ0QsU0FBcUJILCtCQVVwQiJ9