'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
import MetatraderAccountCredentials from './metatraderAccountCredentials';
let MetatraderAccountGeneratorApi = class MetatraderAccountGeneratorApi {
    /**
   * Creates new MetaTrader 4 demo account.
   * See (https://metaapi.cloud/docs/provisioning/api/generateAccount/createMT4DemoAccount/)
   * @param {NewMT4DemoAccount} account account to create
   * @param {string} [profileId] id of the provisioning profile that will be used as the basis for creating this account
   * @return {Promise<MetatraderAccountCredentials>} promise resolving with MetaTrader account credentials entity
   */ createMT4DemoAccount(account, profileId) {
        var _this = this;
        return _async_to_generator(function*() {
            let mtAccount = yield _this._metatraderAccountGeneratorClient.createMT4DemoAccount(account, profileId);
            return new MetatraderAccountCredentials(mtAccount);
        })();
    }
    /**
   * Creates new MetaTrader 5 demo account.
   * See https://metaapi.cloud/docs/provisioning/api/generateAccount/createMT5DemoAccount/
   * @param {NewMT5DemoAccount} account account to create
   * @param {string} [profileId] id of the provisioning profile that will be used as the basis for creating this account
   * @return {Promise<MetatraderAccountCredentials>} promise resolving with MetaTrader account credentials entity
   */ createMT5DemoAccount(account, profileId) {
        var _this = this;
        return _async_to_generator(function*() {
            let mtAccount = yield _this._metatraderAccountGeneratorClient.createMT5DemoAccount(account, profileId);
            return new MetatraderAccountCredentials(mtAccount);
        })();
    }
    /**
   * Constructs a MetaTrader account generator API instance
   * @param {MetatraderAccountGeneratorClient} metatraderAccountGeneratorClient MetaTrader account generator REST API
   * client
   */ constructor(metatraderAccountGeneratorClient){
        this._metatraderAccountGeneratorClient = metatraderAccountGeneratorClient;
    }
};
/**
 * Exposes MetaTrader account generator API logic to the consumers
 */ export { MetatraderAccountGeneratorApi as default };

//# sourceMappingURL=data:application/json;base64,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