'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let ProvisioningProfile = class ProvisioningProfile {
    /**
   * Returns profile id
   * @return {String} profile id
   */ get id() {
        return this._data._id;
    }
    /**
   * Returns profile name
   * @return {String} profile name
   */ get name() {
        return this._data.name;
    }
    /**
   * Returns profile version. Possible values are 4 and 5
   * @return {Number} profile version
   */ get version() {
        return this._data.version;
    }
    /**
   * Returns profile status. Possible values are new and active
   * @return {String} profile status
   */ get status() {
        return this._data.status;
    }
    /**
   * Returns broker timezone name from Time Zone Database
   * @return {String} broker timezone name
   */ get brokerTimezone() {
        return this._data.brokerTimezone;
    }
    /**
   * Returns broker DST timezone name from Time Zone Database
   * @return {String} broker DST switch timezone name
   */ get brokerDSTSwitchTimezone() {
        return this._data.brokerDSTSwitchTimezone;
    }
    /**
   * Reloads provisioning profile from API
   * @return {Promise} promise resolving when provisioning profile is updated
   */ reload() {
        var _this = this;
        return _async_to_generator(function*() {
            _this._data = yield _this._provisioningProfileClient.getProvisioningProfile(_this.id);
        })();
    }
    /**
   * Removes provisioning profile. The current object instance should be discarded after returned promise resolves.
   * @return {Promise} promise resolving when provisioning profile is removed
   */ remove() {
        return this._provisioningProfileClient.deleteProvisioningProfile(this.id);
    }
    /**
   * Uploads a file to provisioning profile.
   * @param {String} fileName name of the file to upload. Allowed values are servers.dat for MT5 profile, broker.srv for
   * MT4 profile
   * @param {String|Buffer} file path to a file to upload or buffer containing file contents
   * @return {Promise} promise which resolves when the file was uploaded
   */ uploadFile(fileName, file) {
        return this._provisioningProfileClient.uploadProvisioningProfileFile(this.id, fileName, file);
    }
    /**
   * Updates provisioning profile
   * @param {ProvisioningProfileUpdateDto} profile provisioning profile update
   * @return {Promise} promise resolving when provisioning profile is updated
   */ update(profile) {
        var _this = this;
        return _async_to_generator(function*() {
            yield _this._provisioningProfileClient.updateProvisioningProfile(_this.id, profile);
            yield _this.reload();
        })();
    }
    /**
   * Constructs a provisioning profile entity
   * @param {ProvisioningProfileDto} data provisioning profile data
   * @param {ProvisioningProfileClient} provisioningProfileClient provisioning profile REST API client
   */ constructor(data, provisioningProfileClient){
        this._data = data;
        this._provisioningProfileClient = provisioningProfileClient;
    }
};
/**
 * Implements a provisioning profile entity
 */ export { ProvisioningProfile as default };

//# sourceMappingURL=data:application/json;base64,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