'use strict';
function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) {
    try {
        var info = gen[key](arg);
        var value = info.value;
    } catch (error) {
        reject(error);
        return;
    }
    if (info.done) {
        resolve(value);
    } else {
        Promise.resolve(value).then(_next, _throw);
    }
}
function _async_to_generator(fn) {
    return function() {
        var self = this, args = arguments;
        return new Promise(function(resolve, reject) {
            var gen = fn.apply(self, args);
            function _next(value) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value);
            }
            function _throw(err) {
                asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err);
            }
            _next(undefined);
        });
    };
}
let TrackerEventListener = class TrackerEventListener {
    /**
   * Returns account id
   */ get accountId() {
        return this._accountId;
    }
    /**
   * Returns tracker id
   */ get trackerId() {
        return this._trackerId;
    }
    /**
   * Processes profit/drawdown event which occurs when a profit/drawdown limit is exceeded in a tracker
   * @param {TrackerEvent} trackerEvent profit/drawdown event
   */ onTrackerEvent(trackerEvent) {
        return _async_to_generator(function*() {
            throw Error('Abstract method onTrackerEvent has no implementation');
        })();
    }
    /**
   * Processes an error event
   * @param {Error} error error received 
   */ onError(error) {
        return _async_to_generator(function*() {})();
    }
    /**
   * Creates a tracker event listener instance
   * @param {string} accountId account id
   * @param {string} trackerId tracker id
   */ constructor(accountId, trackerId){
        if (!accountId) {
            throw Error('Account id parameter required');
        }
        if (!trackerId) {
            throw Error('Tracker id parameter required');
        }
        this._accountId = accountId;
        this._trackerId = trackerId;
    }
};
/**
 * Tracker event listener for handling a stream of profit/drawdown events
 */ export { TrackerEventListener as default };

//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJzb3VyY2VzIjpbIjxhbm9uPiJdLCJzb3VyY2VzQ29udGVudCI6WyIndXNlIHN0cmljdCc7XG5cbi8qKlxuICogVHJhY2tlciBldmVudCBsaXN0ZW5lciBmb3IgaGFuZGxpbmcgYSBzdHJlYW0gb2YgcHJvZml0L2RyYXdkb3duIGV2ZW50c1xuICovXG5leHBvcnQgZGVmYXVsdCBjbGFzcyBUcmFja2VyRXZlbnRMaXN0ZW5lciB7XG5cbiAgLyoqXG4gICAqIENyZWF0ZXMgYSB0cmFja2VyIGV2ZW50IGxpc3RlbmVyIGluc3RhbmNlXG4gICAqIEBwYXJhbSB7c3RyaW5nfSBhY2NvdW50SWQgYWNjb3VudCBpZFxuICAgKiBAcGFyYW0ge3N0cmluZ30gdHJhY2tlcklkIHRyYWNrZXIgaWRcbiAgICovXG4gIGNvbnN0cnVjdG9yKGFjY291bnRJZCwgdHJhY2tlcklkKSB7XG4gICAgaWYoIWFjY291bnRJZCkge1xuICAgICAgdGhyb3cgRXJyb3IoJ0FjY291bnQgaWQgcGFyYW1ldGVyIHJlcXVpcmVkJyk7XG4gICAgfVxuICAgIGlmKCF0cmFja2VySWQpIHtcbiAgICAgIHRocm93IEVycm9yKCdUcmFja2VyIGlkIHBhcmFtZXRlciByZXF1aXJlZCcpO1xuICAgIH1cbiAgICB0aGlzLl9hY2NvdW50SWQgPSBhY2NvdW50SWQ7XG4gICAgdGhpcy5fdHJhY2tlcklkID0gdHJhY2tlcklkO1xuICB9XG5cbiAgLyoqXG4gICAqIFJldHVybnMgYWNjb3VudCBpZFxuICAgKi9cbiAgZ2V0IGFjY291bnRJZCgpIHtcbiAgICByZXR1cm4gdGhpcy5fYWNjb3VudElkO1xuICB9XG4gIFxuICAvKipcbiAgICogUmV0dXJucyB0cmFja2VyIGlkXG4gICAqL1xuICBnZXQgdHJhY2tlcklkKCkge1xuICAgIHJldHVybiB0aGlzLl90cmFja2VySWQ7XG4gIH1cblxuICAvKipcbiAgICogUHJvY2Vzc2VzIHByb2ZpdC9kcmF3ZG93biBldmVudCB3aGljaCBvY2N1cnMgd2hlbiBhIHByb2ZpdC9kcmF3ZG93biBsaW1pdCBpcyBleGNlZWRlZCBpbiBhIHRyYWNrZXJcbiAgICogQHBhcmFtIHtUcmFja2VyRXZlbnR9IHRyYWNrZXJFdmVudCBwcm9maXQvZHJhd2Rvd24gZXZlbnRcbiAgICovXG4gIGFzeW5jIG9uVHJhY2tlckV2ZW50KHRyYWNrZXJFdmVudCkge1xuICAgIHRocm93IEVycm9yKCdBYnN0cmFjdCBtZXRob2Qgb25UcmFja2VyRXZlbnQgaGFzIG5vIGltcGxlbWVudGF0aW9uJyk7XG4gIH1cblxuICAvKipcbiAgICogUHJvY2Vzc2VzIGFuIGVycm9yIGV2ZW50XG4gICAqIEBwYXJhbSB7RXJyb3J9IGVycm9yIGVycm9yIHJlY2VpdmVkIFxuICAgKi9cbiAgYXN5bmMgb25FcnJvcihlcnJvcikge31cblxufSJdLCJuYW1lcyI6WyJUcmFja2VyRXZlbnRMaXN0ZW5lciIsImFjY291bnRJZCIsIl9hY2NvdW50SWQiLCJ0cmFja2VySWQiLCJfdHJhY2tlcklkIiwib25UcmFja2VyRXZlbnQiLCJ0cmFja2VyRXZlbnQiLCJFcnJvciIsIm9uRXJyb3IiLCJlcnJvciIsImNvbnN0cnVjdG9yIl0sIm1hcHBpbmdzIjoiQUFBQTs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7O0FBS2UsSUFBQSxBQUFNQSx1QkFBTixNQUFNQTtJQWtCbkI7O0dBRUMsR0FDRCxJQUFJQyxZQUFZO1FBQ2QsT0FBTyxJQUFJLENBQUNDLFVBQVU7SUFDeEI7SUFFQTs7R0FFQyxHQUNELElBQUlDLFlBQVk7UUFDZCxPQUFPLElBQUksQ0FBQ0MsVUFBVTtJQUN4QjtJQUVBOzs7R0FHQyxHQUNELEFBQU1DLGVBQWVDLFlBQVk7ZUFBakMsb0JBQUE7WUFDRSxNQUFNQyxNQUFNO1FBQ2Q7O0lBRUE7OztHQUdDLEdBQ0QsQUFBTUMsUUFBUUMsS0FBSztlQUFuQixvQkFBQSxhQUFzQjs7SUExQ3RCOzs7O0dBSUMsR0FDREMsWUFBWVQsU0FBUyxFQUFFRSxTQUFTLENBQUU7UUFDaEMsSUFBRyxDQUFDRixXQUFXO1lBQ2IsTUFBTU0sTUFBTTtRQUNkO1FBQ0EsSUFBRyxDQUFDSixXQUFXO1lBQ2IsTUFBTUksTUFBTTtRQUNkO1FBQ0EsSUFBSSxDQUFDTCxVQUFVLEdBQUdEO1FBQ2xCLElBQUksQ0FBQ0csVUFBVSxHQUFHRDtJQUNwQjtBQThCRjtBQWpEQTs7Q0FFQyxHQUNELFNBQXFCSCxrQ0E4Q3BCIn0=