"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "default", {
    enumerable: true,
    get: function() {
        return StatisticalReservoir;
    }
});
const _avlTreeReservoir = /*#__PURE__*/ _interop_require_default(require("./avlTreeReservoir"));
function _interop_require_default(obj) {
    return obj && obj.__esModule ? obj : {
        default: obj
    };
}
let StatisticalReservoir = class StatisticalReservoir {
    /**
   * Add element to reservoir
   * @param {Number} data to add
   */ pushMeasurement(data) {
        this.reservoir.pushSome(data);
        this.length = this.reservoir.size();
    }
    /**
   * Calculate percentile statistics for values stored in reservoir.
   * @param {Number} p - value in percents from 0 to 100
   * @return {Number} percentile value
   */ getPercentile(p) {
        this.length = this.reservoir.size();
        return this.reservoir.getPercentile(p);
    }
    /**
   * Restore reservoir from saving data
   * @param {Object} value - stored value 
   */ restoreValues(value) {
        this.reservoir.restoreValues(value);
    }
    /**
   * 
   * @return {Array} - reservoir array
   */ toArray() {
        return this.reservoir.toArray();
    }
    toValueArray() {
        return this.reservoir.toValueArray();
    }
    /**
   * Constructs reservoir
   * @param {number} size Reservoir size
   * @param {number} interval reservoir interval in milliseconds
   * @param {Function} randomNumberGen custom random generator
   */ constructor(size, interval, randomNumberGen){
        this.reservoir = (0, _avlTreeReservoir.default)(size, interval, randomNumberGen);
        this.length = this.reservoir.size();
    }
};

//# sourceMappingURL=data:application/json;base64,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